#ifdef WIN32

#pragma once

#include "XmppMgr\XMppMgrInterface.h"
#include "Helper.h"
#include "jabberMeeting.h"
#include "JMIMHelper.h"
#include "csfunified/services/interface/InstantMessageCommandCode.h"
#include "csfunified/services/interface/InstantMessageConversationService.h"
#include "csfunified/services/interface/InstantMessageCommandReceivedCallback.h"


namespace CSFUnified
{
	using namespace JabberMeeting;	
	using namespace CSFUnified::InstantMessageCommandCodeEnum;
	using namespace MeetingStackCap;

	class IMMgrHelperCallback: public InstantMessageCommandReceivedCallback
	{
	public:
		IMMgrHelperCallback() {};
		~IMMgrHelperCallback() {};

		//InstantMessageCommandReceivedCallback method
		virtual void OnInstantMessageCommandReceived(std::string uri, std::string participantUri, InstantMessageCommandCodeEnum::InstantMessageCommandCode commandCode, std::string commandContent, std::string plaintext, std::string richtext, bool isGroupChatCmd);
	};

	class IMMgrHelper :// public ComponentManager<IIMMgr,_IIMMgrEvent>,
						public IJMIMDelegete						
	{
	public:
		IMMgrHelper();
		virtual ~IMMgrHelper();

// 		virtual stdapi OnIMReceived(IN const wstring& strBareJid,IN const XM_TriInstantMessage* pIM) { return CON_S_OK; };
// 		virtual stdapi OnBroadcastMessageReceived(IN const wstring& strBareJid, IN const XM_TriInstantMessage* pIM) { return CON_S_OK; };
// 		virtual stdapi OnIMCmdReceived(IN ATUInt32 uCmd , IN const XM_TRI_IMCMD *pImCmd, OUT BOOL* vbHandled);
// 		virtual stdapi OnInputStateChanged(IN const wstring& strSessionName, IN const XM_TriInputState* pInputState) { return CON_S_OK; };
// 		virtual stdapi OnImLogNotificationReceived(IN const wstring& strBareJid, IN const XM_TriInstantMessage* pIM ){ return CON_S_OK; };
// 		virtual stdapi OnAesStatusChanged(IN const wstring& strBareJid, IN const XM_AES_RESULT* aesResult) { return CON_S_OK; };
// 		virtual stdapi OnImResult(IN const wstring& strBareJid, IN const XM_TriInstantMessage* pIM) { return CON_S_OK; };
// 		virtual stdapi OnImCmdResult(IN const wstring& strBareJid, IN const XM_TRI_IMCMD* pcmd) { return CON_S_OK; };
// 
// 		virtual stdapi OnJingleCmdReceived(IN ATUInt32 uCmd,IN const XM_TRI_IMCMD *pImCmd) { return CON_S_OK; };
// 		virtual stdapi OnNotificationReceived(IN const wstring& bstrNotification) { return CON_S_OK; }

		virtual BOOL SendCmd_DSInvitation(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);
		virtual BOOL SendCmd_DSDecline(wstring& strSessionName, wstring& strCmdMsg);
		virtual BOOL SendCmd_DSCancelled(wstring& strSessionName, wstring& strCmdMsg);
		virtual BOOL SendCmd_MeetingInvitation(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);
		virtual BOOL SendCmd_MeetingDecline(wstring& strSessionName, wstring& strCmdMsg);
		virtual BOOL SendCmd_MeetingCancelled(wstring& strSessionName, wstring& strCmdMsg);
		
		void SendCmd_CMRMeetingInvitation(const std::string& JID, const std::string& strCmdMsg, const std::string& htmlMsg, const std::string plainMsg);	////add it for CMR with compatible with old client

	    void SendAutoRespPolicy(wstring const& strBareJid, int eResult);
		
		// Meeting-IMAlert
		virtual BOOL SendCmd_IMAlert(const wstring& strBuddyName, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage);
		void Init();
	private:
		BOOL SendIMCmd(const wstring& strBuddyKey, INT cmd, const wstring& strCmd, const wstring& strHtmlMessage, const wstring& strPlainMessage, IN const wstring& strLogMsg);
		bool SendIMCmdEx(const std::string& strBuddyKey, INT cmd, const std::string& strCmd, const std::string& strHtmlMessage, const std::string& strPlainMessage, IN const std::string& strLogMsg);
		InstantMessageConversationService* GetProvider();
		void RegisterImCallback();
		void UnRegisterImCallback();

	private:
		InstantMessageConversationService* m_pImProvider;
		SMART_PTR_NS::shared_ptr<IMMgrHelperCallback> m_pCallback;
	};
}

#endif